/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretrooms.server.blocks;

import com.wynprice.secretrooms.server.blocks.SecretBaseBlock;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class SecretButton
extends SecretBaseBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    private final boolean wooden;

    public SecretButton(BlockBehaviour.Properties properties, boolean wooden) {
        super(properties);
        this.wooden = wooden;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{POWERED});
    }

    public int tickRate(LevelReader worldIn) {
        return this.wooden ? 30 : 20;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            return InteractionResult.SUCCESS;
        }
        worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.TRUE), 3);
        this.playSound(player, (LevelAccessor)worldIn, pos, true);
        this.updateNeighbors(worldIn, pos);
        worldIn.m_186460_(pos, (Block)this, this.tickRate((LevelReader)worldIn));
        return InteractionResult.SUCCESS;
    }

    private void playSound(@Nullable Player player, LevelAccessor world, BlockPos pos, boolean turnOn) {
        SoundEvent woodenEvent = turnOn ? SoundEvents.f_12632_ : SoundEvents.f_12631_;
        SoundEvent stoneEvent = turnOn ? SoundEvents.f_12444_ : SoundEvents.f_12443_;
        world.m_5594_((Player)(turnOn ? player : null), pos, this.wooden ? woodenEvent : stoneEvent, SoundSource.BLOCKS, 0.3f, turnOn ? 0.6f : 0.5f);
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && state.m_60734_() != newState.m_60734_()) {
            if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
                this.updateNeighbors(worldIn, pos);
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.m_61143_((Property)POWERED) != false ? 15 : 0;
    }

    public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
        return (Boolean)state.m_61143_((Property)POWERED) == false;
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random rand) {
        if (!worldIn.f_46443_ && ((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            if (this.wooden) {
                this.checkPressed(state, (Level)worldIn, pos);
            } else {
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.FALSE), 3);
                this.updateNeighbors((Level)worldIn, pos);
                this.playSound(null, (LevelAccessor)worldIn, pos, false);
            }
        }
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (!worldIn.f_46443_ && this.wooden && !((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            this.checkPressed(state, worldIn, pos);
        }
    }

    private void checkPressed(BlockState state, Level worldIn, BlockPos pos) {
        boolean flag1;
        List list = worldIn.m_45976_(AbstractArrow.class, state.m_60808_((BlockGetter)worldIn, pos).m_83215_().m_82338_(pos));
        boolean flag = !list.isEmpty();
        if (flag != (flag1 = ((Boolean)state.m_61143_((Property)POWERED)).booleanValue())) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(flag)), 3);
            this.updateNeighbors(worldIn, pos);
            this.playSound(null, (LevelAccessor)worldIn, pos, flag);
        }
        if (flag) {
            worldIn.m_186460_(new BlockPos((Vec3i)pos), (Block)this, this.tickRate((LevelReader)worldIn));
        }
    }

    private void updateNeighbors(Level world, BlockPos pos) {
        world.m_46672_(pos, (Block)this);
        for (Direction value : Direction.values()) {
            world.m_46672_(pos.m_142300_(value.m_122424_()), (Block)this);
        }
    }
}

